<?php
	error_reporting(E_ALL);
	ini_set('display_errors','on');
	checkInstall();
	//include 'jquery-ui-1.10.2.custom.all.css';
	//include 'jquery.js';
	include 'server.html.php';
	include 'style.html.php';
	
	$settings = get_user_state();

	/*========================================================================================*/
	$sort = '';
	if(isset($_GET['sort']))
		$sort = $_GET['sort'];
	if(isset($_POST['sort']))
		$sort = $_POST['sort'];
		
	$cur_page = 1;
	if(isset($_GET['current_page']) && is_numeric($_GET['current_page']))
		$cur_page = $_GET['current_page'];
	else if(isset($_POST['current_page']) && is_numeric($_POST['current_page']))
		$cur_page = $_POST['current_page'];
?>
<div id="sender">
	<h1>OpenVox SMS Sender</h1>
	<br />
	<div><button id="but-setting" class='but'>Show Settings</button></div>
	<br />
	<div id="settings">
		<form id="form_settings">
			<input type="hidden" name="state" value="user_settings" />
			<table width="100%" border="0" id="tab-settings">
				<caption class="cap2">HTTP to SMS settings</caption>
				<tr>
					<td width="200">User Name</td>
					<td>
						<input type="text" name="username" id="sms_username" value="<?php echo $settings['username']; ?>" />
					</td>
				</tr>
				<tr>
					<td>Password</td>
					<td><input type="password" name="password" id="sms_password" value="<?php echo $settings['password']; ?>" /></td>
				</tr>
				<tr>
					<td>Ports</td>
					<td>
						<select name="ports" id="board">
						<?php
							for($i=4;$i<=44;$i+=4){
								$selected = ($settings['port'] == $i )?'selected="selected"':'';
								echo "<option value='$i' {$selected}>$i</option>";
							}
						?>
						</select>
						<div id="port_opt"></div>
					</td>
				</tr>
			</table>
			<button id="btn-sub" class="but">Save</button>
			<span id="settings_msg"></span>
			<button id="btn-sub-all" class="but ml50">All</button>
		</form>
	</div>
	<br />
	<p class="cap2">Send messages</p>
	<form id="sms_send">
		<input type="hidden" name="state" value="send_msg" />
		<div class="para">
			<span class="title">IP or domain of SMS Gateway</span>
			<input type="text" name="sms_ip" id="sms_ip" value="<?php echo $settings['ip_addr'];?>"/>
			<input type="checkbox" id="save_ip" />
			<?php if( isset($settings['ip_addr']) && $settings['ip_addr'] != ''){ ?>
				<span class='ip_status'>Do not save IP. </span>
			<?php }else{ ?>
				<span class='ip_status'>Save IP.</span>
			<?php } ?>
		</div>
		<div class="para">
			<span class="title">Phone Number</span>
			<textarea name="sms_number" id="sms_number" cols="30" rows="5"><?php if(isset($_POST['org_number']))echo $_POST['org_number'];?></textarea>
			<span id="sms_number_msg"></span>
			<input type="file" name="num_file" id="num_file" onchange="readfiles();" value="yes"/>
		</div>
		<div class="para">
			<span class="title">Message</span>
			<textarea name="sms_content" id="sms_content" cols="50" rows="6" ><?php if(isset($_POST['org_content']))echo $_POST['org_content'];?></textarea>
			<span id="sms_content_msg"></span>
		</div>
		<div class="para">
			<span class="title">Action</span>
			<button id="send" class="but">Send</button>
			<span id="send_waring"></span>
		</div>
	</form>
	<br />
	<table border="1" width="100%" id="sms_detail">
		<tr>
			<td>Message</td>
			<td width="300">Destination Number</td>
			<td>Port</td>
			<td width="320">Result</td>
		</tr>
	</table>
	<br />
	<button id="receive_box" class="but">Receive SMS</button>
</div>
<div id="receiver">
	<button id="send_sms" class="but">Send SMS</button>
	<button id="fresh" class="but">Fresh</button>
	<br />
	<br />
	<p class="p2">SMS In Box</p>
	<br />
	<?php include 'receive.html.php'; ?>
</div>

<?php include 'js.js';?>
<?php include 'functions.js';?>
<?php include 'ui-timepicker.js';?>
<?php //include 'jquery-ui-1.10.2.custom.all.min.js';?>
<?php //include 'jquery-ui-timepicker-addon.js';?>
<?php //include 'jquery-ui-sliderAccess.js';?>
